LIBRARY IEEE; 
USE IEEE.std_logic_1164.ALL;
ENTITY counter IS
  PORT(load, clear, clk : IN std_logic;
       data_in : IN INTEGER;
       data_out : OUT INTEGER);
END counter;

ARCHITECTURE count_255 OF counter IS
BEGIN
  PROCESS(clk)
    VARIABLE count : INTEGER := 0;
  BEGIN
    IF clear = '1' THEN
      count := 0;
    ELSIF load = '1' THEN
      count := data_in;
    ELSE
      IF (clk'EVENT) AND (clk = '1') AND
         (clk'LAST_VALUE = '0') THEN
        IF (count = 255) THEN
          count := 0;
        ELSE
          count := count + 1;
        END IF;
      END IF;
    END IF;
    data_out <= count;
  END PROCESS;
END count_255;

ARCHITECTURE count_64k OF counter IS
BEGIN
  PROCESS(clk)
    VARIABLE count : INTEGER := 0;
  BEGIN
    IF clear = '1' THEN
      count := 0;
    ELSIF load = '1' THEN
      count := data_in;
    ELSE
      IF (clk'EVENT) AND (clk = '1') AND
         (clk'LAST_VALUE = '0') THEN
        IF (count = 65535) THEN
          count := 0;
        ELSE
          count := count + 1;
        END IF;
      END IF;
    END IF;
    data_out <= count;
  END PROCESS;
END count_64k;

CONFIGURATION small_count OF counter IS
  FOR count_255
  END FOR;
END small_count;

CONFIGURATION big_count OF counter IS
  FOR count_64k
  END FOR;
END big_count;
